/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.xml.sax.InputSource;

public class XPathSplitStreamTest
extends ContextTestSupport {
    private static int size = 100;

    @Override
    protected void setUp() throws Exception {
        XPathSplitStreamTest.deleteDirectory("target/file/xpathsplit");
        super.setUp();
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("\n<persons>");
        for (int i = 0; i < size; ++i) {
            sb.append("\n<person><id>" + i + "</id><name>John Doe</name></person>");
        }
        sb.append("\n</persons>");
        this.template.sendBodyAndHeader("file://target/file/xpathsplit", (Object)sb.toString(), "CamelFileName", (Object)"bigfile.xml");
    }

    public void testXPathSplitStream() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:splitted");
        mock.expectedMessageCount(size);
        mock.expectsNoDuplicates().body();
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file://target/file/xpathsplit").split((Expression)this.xpath("/persons/person").documentType(InputSource.class)).streaming().to("mock:splitted");
            }
        };
    }
}

