/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.List;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.api.management.mbean.BacklogTracerEventMessage;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class BacklogTracerFilterTest
extends ManagementTestSupport {
    public void testBacklogTracerFilter() throws Exception {
        if (BacklogTracerFilterTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=camel-1,type=tracer,name=BacklogTracer");
        BacklogTracerFilterTest.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        BacklogTracerFilterTest.assertEquals((String)"Should not be enabled", (Object)Boolean.FALSE, (Object)enabled);
        Integer size = (Integer)mbeanServer.getAttribute(on, "BacklogSize");
        BacklogTracerFilterTest.assertEquals((String)"Should be 1000", (int)1000, (int)size);
        mbeanServer.setAttribute(on, new Attribute("TraceFilter", "${header.foo} != null"));
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "foo", (Object)123);
        this.assertMockEndpointsSatisfied();
        List exchanges = this.getMockEndpoint("mock:foo").getReceivedExchanges();
        List events = (List)mbeanServer.invoke(on, "dumpAllTracedMessages", null, null);
        BacklogTracerFilterTest.assertNotNull((Object)events);
        BacklogTracerFilterTest.assertEquals((int)3, (int)events.size());
        BacklogTracerEventMessage event = (BacklogTracerEventMessage)events.get(0);
        BacklogTracerFilterTest.assertEquals(null, (String)event.getToNode());
        BacklogTracerFilterTest.assertEquals((String)("    <message exchangeId=\"" + ((Exchange)exchanges.get(1)).getExchangeId() + "\">\n" + "      <headers>\n" + "        <header key=\"foo\" type=\"java.lang.Integer\">123</header>\n" + "      </headers>\n" + "      <body type=\"java.lang.String\">Bye World</body>\n" + "    </message>"), (String)event.getMessageAsXml());
        BacklogTracerEventMessage event1 = (BacklogTracerEventMessage)events.get(1);
        BacklogTracerFilterTest.assertEquals((String)"foo", (String)event1.getToNode());
        BacklogTracerFilterTest.assertEquals((String)("    <message exchangeId=\"" + ((Exchange)exchanges.get(1)).getExchangeId() + "\">\n" + "      <headers>\n" + "        <header key=\"foo\" type=\"java.lang.Integer\">123</header>\n" + "      </headers>\n" + "      <body type=\"java.lang.String\">Bye World</body>\n" + "    </message>"), (String)event1.getMessageAsXml());
        BacklogTracerEventMessage event2 = (BacklogTracerEventMessage)events.get(2);
        BacklogTracerFilterTest.assertEquals((String)"bar", (String)event2.getToNode());
        BacklogTracerFilterTest.assertEquals((String)("    <message exchangeId=\"" + ((Exchange)exchanges.get(1)).getExchangeId() + "\">\n" + "      <headers>\n" + "        <header key=\"foo\" type=\"java.lang.Integer\">123</header>\n" + "      </headers>\n" + "      <body type=\"java.lang.String\">Bye World</body>\n" + "    </message>"), (String)event2.getMessageAsXml());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                BacklogTracerFilterTest.this.context.setUseBreadcrumb(Boolean.valueOf(false));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:foo")).id("foo")).to("mock:bar")).id("bar");
            }
        };
    }
}

