/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedCamelContextSuspendStartTest
extends ManagementTestSupport {
    public void testManagedCamelContext() throws Exception {
        if (ManagedCamelContextSuspendStartTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=context,name=\"camel-1\"");
        ManagedCamelContextSuspendStartTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        String name = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedCamelContextSuspendStartTest.assertEquals((String)"camel-1", (String)name);
        String uptime = (String)mbeanServer.getAttribute(on, "Uptime");
        ManagedCamelContextSuspendStartTest.assertNotNull((Object)uptime);
        long uptimeMillis = (Long)mbeanServer.getAttribute(on, "UptimeMillis");
        ManagedCamelContextSuspendStartTest.assertTrue((uptimeMillis > 0L ? 1 : 0) != 0);
        String status = (String)mbeanServer.getAttribute(on, "State");
        ManagedCamelContextSuspendStartTest.assertEquals((String)"Started", (String)status);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        Object reply = mbeanServer.invoke(on, "requestBody", new Object[]{"direct:foo", "Hello World"}, new String[]{"java.lang.String", "java.lang.Object"});
        ManagedCamelContextSuspendStartTest.assertEquals((Object)"Bye World", (Object)reply);
        mbeanServer.invoke(on, "suspend", null, null);
        status = (String)mbeanServer.getAttribute(on, "State");
        ManagedCamelContextSuspendStartTest.assertEquals((String)"Suspended", (String)status);
        mbeanServer.invoke(on, "start", null, null);
        status = (String)mbeanServer.getAttribute(on, "State");
        ManagedCamelContextSuspendStartTest.assertEquals((String)"Started", (String)status);
        reply = mbeanServer.invoke(on, "requestBody", new Object[]{"direct:foo", "Hello Camel"}, new String[]{"java.lang.String", "java.lang.Object"});
        ManagedCamelContextSuspendStartTest.assertEquals((Object)"Bye World", (Object)reply);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:foo").transform((Expression)this.constant("Bye World"));
            }
        };
    }
}

