/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedMarshalTest
extends ManagementTestSupport {
    public void testManageMarshal() throws Exception {
        if (ManagedMarshalTest.isPlatform("aix")) {
            return;
        }
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedMarshalTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedMarshalTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedMarshalTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        String name = (String)mbeanServer.getAttribute(on, "DataFormatName");
        ManagedMarshalTest.assertEquals((String)"string", (String)name);
        String xml = (String)mbeanServer.invoke(on, "dumpProcessorAsXml", null, null);
        ManagedMarshalTest.assertTrue((boolean)xml.contains("<marshal"));
        ManagedMarshalTest.assertTrue((boolean)xml.contains("</marshal>"));
        ManagedMarshalTest.assertTrue((boolean)xml.contains("<string charset=\"iso-8859-1\"/>"));
        TabularData data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedMarshalTest.assertNotNull((Object)data);
        ManagedMarshalTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedMarshalTest.assertNotNull((Object)data);
        ManagedMarshalTest.assertEquals((int)4, (int)data.size());
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedMarshalTest.assertNotNull((Object)json);
        ManagedMarshalTest.assertTrue((boolean)json.contains("\"description\": \"Marshals data into a specified format for transmission over a transport or component"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").marshal().string("iso-8859-1").id("mysend")).to("mock:foo");
            }
        };
    }
}

