/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedNamePatternFixedTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementNameStrategy().setNamePattern("cool");
        return context;
    }

    public void testManagedNamePattern() throws Exception {
        if (ManagedNamePatternFixedTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ManagedNamePatternFixedTest.assertEquals((String)"cool", (String)this.context.getManagementName());
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=" + this.context.getManagementName() + ",type=context,name=\"camel-1\"");
        ManagedNamePatternFixedTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

