/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.DefaultManagementNamingStrategy;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedNamePatternIncludeHostNameTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        DefaultManagementNamingStrategy naming = (DefaultManagementNamingStrategy)context.getManagementStrategy().getManagementNamingStrategy();
        naming.setHostName("localhost");
        context.getManagementStrategy().getManagementAgent().setIncludeHostName(Boolean.valueOf(true));
        context.getManagementNameStrategy().setNamePattern("cool-#name#");
        return context;
    }

    public void testManagedNamePattern() throws Exception {
        if (ManagedNamePatternIncludeHostNameTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ManagedNamePatternIncludeHostNameTest.assertTrue((boolean)this.context.getManagementName().startsWith("cool"));
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=localhost/" + this.context.getManagementName() + ",type=context,name=\"camel-1\"");
        ManagedNamePatternIncludeHostNameTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

