/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.CamelContext;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.PollEnrichDefinition;

public class ManagedPollEnricherTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementStrategy().getManagementAgent().setStatisticsLevel(ManagementStatisticsLevel.Extended);
        return context;
    }

    public void testManagePollEnricher() throws Exception {
        if (ManagedPollEnricherTest.isPlatform("aix")) {
            return;
        }
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello", "whereto", (Object)"foo");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedPollEnricherTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedPollEnricherTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedPollEnricherTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        Long timout = (Long)mbeanServer.getAttribute(on, "Timeout");
        ManagedPollEnricherTest.assertEquals((long)1000L, (long)timout);
        String lan = (String)mbeanServer.getAttribute(on, "ExpressionLanguage");
        ManagedPollEnricherTest.assertEquals((String)"simple", (String)lan);
        String uri = (String)mbeanServer.getAttribute(on, "Expression");
        ManagedPollEnricherTest.assertEquals((String)"seda:${header.whereto}", (String)uri);
        TabularData data = (TabularData)mbeanServer.invoke(on, "extendedInformation", null, null);
        ManagedPollEnricherTest.assertNotNull((Object)data);
        ManagedPollEnricherTest.assertEquals((int)1, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedPollEnricherTest.assertNotNull((Object)data);
        ManagedPollEnricherTest.assertEquals((int)3, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedPollEnricherTest.assertNotNull((Object)data);
        ManagedPollEnricherTest.assertEquals((int)10, (int)data.size());
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedPollEnricherTest.assertNotNull((Object)json);
        ManagedPollEnricherTest.assertTrue((boolean)json.contains("\"description\": \"Enriches messages with data polled from a secondary resource"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((PollEnrichDefinition)this.from("direct:start").pollEnrich().simple("seda:${header.whereto}")).timeout(1000L).id("mysend").to("mock:foo");
            }
        };
    }
}

