/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.Expression;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ResequenceDefinition;

public class ManagedResequencerTest
extends ManagementTestSupport {
    public void testManageResequencer() throws Exception {
        if (ManagedResequencerTest.isPlatform("aix")) {
            return;
        }
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedBodiesReceived(new Object[]{"A", "B", "C"});
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "num", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "num", (Object)"3");
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "num", (Object)"1");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedResequencerTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedResequencerTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedResequencerTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        String uri = (String)mbeanServer.getAttribute(on, "Expression");
        ManagedResequencerTest.assertEquals((String)"header(num)", (String)uri);
        Integer size = (Integer)mbeanServer.getAttribute(on, "BatchSize");
        ManagedResequencerTest.assertEquals((int)3, (int)size);
        TabularData data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedResequencerTest.assertNotNull((Object)data);
        ManagedResequencerTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedResequencerTest.assertNotNull((Object)data);
        ManagedResequencerTest.assertEquals((int)5, (int)data.size());
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedResequencerTest.assertNotNull((Object)json);
        ManagedResequencerTest.assertTrue((boolean)json.contains("\"description\": \"Resequences (re-order) messages based on an expression"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ResequenceDefinition)this.from("direct:start").resequence((Expression)this.header("num")).size(3).id("mysend")).to("mock:foo");
            }
        };
    }
}

