/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedRouteDumpRouteAsXmlPlaceholderTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext answer = super.createCamelContext();
        PropertiesComponent pc = new PropertiesComponent();
        pc.setLocation("classpath:org/apache/camel/management/rest.properties");
        answer.addComponent("properties", (Component)pc);
        return answer;
    }

    public void testDumpAsXml() throws Exception {
        if (ManagedRouteDumpRouteAsXmlPlaceholderTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteDumpRouteAsXmlPlaceholderTest.getRouteObjectName(mbeanServer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedRouteDumpRouteAsXmlPlaceholderTest.assertEquals((String)"myRoute", (String)routeId);
        String xml = (String)mbeanServer.invoke(on, "dumpRouteAsXml", new Object[]{true}, new String[]{"boolean"});
        ManagedRouteDumpRouteAsXmlPlaceholderTest.assertNotNull((Object)xml);
        this.log.info(xml);
        ManagedRouteDumpRouteAsXmlPlaceholderTest.assertTrue((boolean)xml.contains("direct:start"));
        ManagedRouteDumpRouteAsXmlPlaceholderTest.assertTrue((boolean)xml.contains("route"));
        ManagedRouteDumpRouteAsXmlPlaceholderTest.assertTrue((boolean)xml.contains("myRoute"));
        ManagedRouteDumpRouteAsXmlPlaceholderTest.assertTrue((boolean)xml.contains("mock:result"));
    }

    static ObjectName getRouteObjectName(MBeanServer mbeanServer) throws Exception {
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRouteDumpRouteAsXmlPlaceholderTest.assertEquals((int)1, (int)set.size());
        return set.iterator().next();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("{{start}}").routeId("myRoute").log("Got ${body}")).to("{{result}}");
            }
        };
    }
}

