/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedRouteRemoveContextScopedErrorHandlerTest
extends ManagementTestSupport {
    public void testRemove() throws Exception {
        if (ManagedRouteRemoveContextScopedErrorHandlerTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ManagedRouteRemoveContextScopedErrorHandlerTest.getRouteObjectName(mbeanServer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteRemoveContextScopedErrorHandlerTest.assertEquals((String)"Should be started", (String)ServiceStatus.Started.name(), (String)state);
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=errorhandlers,*"), null);
        ManagedRouteRemoveContextScopedErrorHandlerTest.assertEquals((int)1, (int)set.size());
        mbeanServer.invoke(on, "stop", null, null);
        state = (String)mbeanServer.getAttribute(on, "State");
        ManagedRouteRemoveContextScopedErrorHandlerTest.assertEquals((String)"Should be stopped", (String)ServiceStatus.Stopped.name(), (String)state);
        mbeanServer.invoke(on, "remove", null, null);
        boolean registered = mbeanServer.isRegistered(on);
        ManagedRouteRemoveContextScopedErrorHandlerTest.assertFalse((String)"Route mbean should have been unregistered", (boolean)registered);
        set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRouteRemoveContextScopedErrorHandlerTest.assertEquals((int)0, (int)set.size());
        set = mbeanServer.queryNames(new ObjectName("*:type=errorhandlers,*"), null);
        ManagedRouteRemoveContextScopedErrorHandlerTest.assertEquals((int)1, (int)set.size());
    }

    static ObjectName getRouteObjectName(MBeanServer mbeanServer) throws Exception {
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedRouteRemoveContextScopedErrorHandlerTest.assertEquals((int)1, (int)set.size());
        return set.iterator().next();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead"));
                this.from("seda:foo").to("mock:result");
            }
        };
    }
}

