/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;

public class ManagedStatisticsWithSplitterTest
extends ManagementTestSupport {
    public void testManageStatistics() throws Exception {
        if (ManagedStatisticsWithSplitterTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"route-a\"");
        Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedStatisticsWithSplitterTest.assertEquals((long)0L, (long)completed);
        this.template.sendBody("direct:start", (Object)"A,B,C");
        this.template.sendBody("direct:start", (Object)"D,E");
        completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedStatisticsWithSplitterTest.assertEquals((long)2L, (long)completed);
        ObjectName foo = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"foo\"");
        completed = (Long)mbeanServer.getAttribute(foo, "ExchangesCompleted");
        ManagedStatisticsWithSplitterTest.assertEquals((long)2L, (long)completed);
        ObjectName bar = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"bar\"");
        completed = (Long)mbeanServer.getAttribute(bar, "ExchangesCompleted");
        ManagedStatisticsWithSplitterTest.assertEquals((long)5L, (long)completed);
        ObjectName mock = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mock\"");
        completed = (Long)mbeanServer.getAttribute(mock, "ExchangesCompleted");
        ManagedStatisticsWithSplitterTest.assertEquals((long)2L, (long)completed);
        on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"route-b\"");
        completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedStatisticsWithSplitterTest.assertEquals((long)5L, (long)completed);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("route-a").to("log:foo")).id("foo")).split((Expression)this.body().tokenize(",")).to("direct:split")).end().to("mock:result").id("mock");
                ((RouteDefinition)this.from("direct:split").routeId("route-b").to("log:bar")).id("bar");
            }
        };
    }
}

