/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.File;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.RoutePolicySupport;

public class ManagedSuspendedServiceTest
extends ManagementTestSupport {
    @Override
    protected void setUp() throws Exception {
        ManagedSuspendedServiceTest.deleteDirectory("target/suspended");
        super.setUp();
    }

    public void testConsumeSuspendAndResumeFile() throws Exception {
        if (ManagedSuspendedServiceTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        ManagedSuspendedServiceTest.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        boolean registered = mbeanServer.isRegistered(on);
        ManagedSuspendedServiceTest.assertEquals((String)"Should be registered", (boolean)true, (boolean)registered);
        Boolean ss = (Boolean)mbeanServer.getAttribute(on, "SupportSuspension");
        ManagedSuspendedServiceTest.assertEquals((boolean)true, (boolean)ss);
        Boolean suspended = (Boolean)mbeanServer.getAttribute(on, "Suspended");
        ManagedSuspendedServiceTest.assertEquals((boolean)false, (boolean)suspended);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("file://target/suspended", (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.template.sendBodyAndHeader("file://target/suspended", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        Thread.sleep(1000L);
        suspended = (Boolean)mbeanServer.getAttribute(on, "Suspended");
        ManagedSuspendedServiceTest.assertEquals((boolean)true, (boolean)suspended);
        String[] files = new File("target/suspended/").list();
        ManagedSuspendedServiceTest.assertNotNull((Object)files);
        ManagedSuspendedServiceTest.assertEquals((String)"The file should exists", (int)1, (int)files.length);
        mock.reset();
        mock.expectedMessageCount(1);
        mbeanServer.invoke(on, "resume", null, null);
        this.assertMockEndpointsSatisfied();
        suspended = (Boolean)mbeanServer.getAttribute(on, "Suspended");
        ManagedSuspendedServiceTest.assertEquals((boolean)false, (boolean)suspended);
        Thread.sleep(500L);
        files = new File("target/suspended/").list();
        ManagedSuspendedServiceTest.assertNotNull((Object)files);
        ManagedSuspendedServiceTest.assertEquals((String)"The file should exists", (int)0, (int)files.length);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                MyPolicy myPolicy = new MyPolicy();
                ((RouteDefinition)this.from("file://target/suspended?maxMessagesPerPoll=1&delete=true").routePolicy(new RoutePolicy[]{myPolicy}).id("myRoute")).to("mock:result");
            }
        };
    }

    private static class MyPolicy
    extends RoutePolicySupport {
        private int counter;

        private MyPolicy() {
        }

        public void onExchangeDone(Route route, Exchange exchange) {
            if (this.counter++ == 0) {
                try {
                    super.stopConsumer(route.getConsumer());
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        }
    }
}

