/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.LoadBalanceDefinition;

public class ManagedTopicLoadBalancerTest
extends ManagementTestSupport {
    public void testManageTopicLoadBalancer() throws Exception {
        if (ManagedTopicLoadBalancerTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedTopicLoadBalancerTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedTopicLoadBalancerTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedTopicLoadBalancerTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        Integer size = (Integer)mbeanServer.getAttribute(on, "Size");
        ManagedTopicLoadBalancerTest.assertEquals((int)2, (int)size);
        TabularData data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedTopicLoadBalancerTest.assertNotNull((Object)data);
        ManagedTopicLoadBalancerTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedTopicLoadBalancerTest.assertNotNull((Object)data);
        ManagedTopicLoadBalancerTest.assertEquals((int)5, (int)data.size());
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedTopicLoadBalancerTest.assertNotNull((Object)json);
        ManagedTopicLoadBalancerTest.assertTrue((boolean)json.contains("\"description\": \"Balances message processing among a number of nodes"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((LoadBalanceDefinition)this.from("direct:start").loadBalance().topic().id("mysend")).to(new String[]{"mock:foo", "mock:bar"});
            }
        };
    }
}

