/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.LoadBalanceDefinition;

public class ManagedWeightedLoadBalancerTest
extends ManagementTestSupport {
    public void testManageWeightedLoadBalancer() throws Exception {
        if (ManagedWeightedLoadBalancerTest.isPlatform("aix")) {
            return;
        }
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(1);
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMessageCount(2);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "foo", (Object)"123");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hi World", "foo", (Object)"123");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedWeightedLoadBalancerTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedWeightedLoadBalancerTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedWeightedLoadBalancerTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        Integer size = (Integer)mbeanServer.getAttribute(on, "Size");
        ManagedWeightedLoadBalancerTest.assertEquals((int)2, (int)size);
        Boolean roundRobin = (Boolean)mbeanServer.getAttribute(on, "RoundRobin");
        ManagedWeightedLoadBalancerTest.assertEquals((boolean)true, (boolean)roundRobin);
        String ratio = (String)mbeanServer.getAttribute(on, "DistributionRatio");
        ManagedWeightedLoadBalancerTest.assertEquals((String)"1,2", (String)ratio);
        String delim = (String)mbeanServer.getAttribute(on, "DistributionRatioDelimiter");
        ManagedWeightedLoadBalancerTest.assertEquals((String)",", (String)delim);
        String last = (String)mbeanServer.getAttribute(on, "LastChosenProcessorId");
        ManagedWeightedLoadBalancerTest.assertEquals((String)"bar", (String)last);
        TabularData data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedWeightedLoadBalancerTest.assertNotNull((Object)data);
        ManagedWeightedLoadBalancerTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedWeightedLoadBalancerTest.assertNotNull((Object)data);
        ManagedWeightedLoadBalancerTest.assertEquals((int)5, (int)data.size());
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedWeightedLoadBalancerTest.assertNotNull((Object)json);
        ManagedWeightedLoadBalancerTest.assertTrue((boolean)json.contains("\"description\": \"Balances message processing among a number of nodes"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((LoadBalanceDefinition)((LoadBalanceDefinition)((LoadBalanceDefinition)((LoadBalanceDefinition)this.from("direct:start").loadBalance().weighted(true, "1,2").id("mysend")).to("mock:foo")).id("foo")).to("mock:bar")).id("bar");
            }
        };
    }
}

