/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.CamelContext;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedWireTapTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementStrategy().getManagementAgent().setStatisticsLevel(ManagementStatisticsLevel.Extended);
        return context;
    }

    public void testManageWireTap() throws Exception {
        if (ManagedWireTapTest.isPlatform("aix")) {
            return;
        }
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(2);
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "whereto", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "whereto", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hi World", "whereto", (Object)"bar");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedWireTapTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedWireTapTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedWireTapTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        String uri = (String)mbeanServer.getAttribute(on, "Uri");
        ManagedWireTapTest.assertEquals((String)"direct:${header.whereto}", (String)uri);
        TabularData data = (TabularData)mbeanServer.invoke(on, "extendedInformation", null, null);
        ManagedWireTapTest.assertNotNull((Object)data);
        ManagedWireTapTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedWireTapTest.assertNotNull((Object)data);
        ManagedWireTapTest.assertEquals((int)3, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedWireTapTest.assertNotNull((Object)data);
        ManagedWireTapTest.assertEquals((int)11, (int)data.size());
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedWireTapTest.assertNotNull((Object)json);
        ManagedWireTapTest.assertTrue((boolean)json.contains("\"description\": \"Routes a copy of a message (or creates a new message) to a secondary destination while continue routing the original message"));
        ManagedWireTapTest.assertTrue((boolean)json.contains(" \"uri\": { \"kind\": \"attribute\", \"required\": \"true\", \"type\": \"string\", \"javaType\": \"java.lang.String\", \"deprecated\": \"false\", \"value\": \"direct:${header.whereto}\""));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").wireTap("direct:${header.whereto}").id("mysend");
                this.from("direct:foo").to("mock:foo");
                this.from("direct:bar").to("mock:bar");
            }
        };
    }
}

