/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.io.InputStream;
import java.util.Collection;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.RouteContext;

public class LoadRouteFromXmlWithPolicyTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyPolicy("foo"));
        return jndi;
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testLoadRouteFromXmlWitPolicy() throws Exception {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("barPolicyRoute.xml");
        RoutesDefinition routes = this.context.loadRoutesDefinition(is);
        this.context.addRouteDefinitions((Collection)routes.getRoutes());
        this.context.start();
        LoadRouteFromXmlWithPolicyTest.assertNotNull((String)"Loaded foo route should be there", (Object)this.context.getRoute("foo"));
        LoadRouteFromXmlWithPolicyTest.assertNotNull((String)"Loaded bar route should be there", (Object)this.context.getRoute("bar"));
        LoadRouteFromXmlWithPolicyTest.assertEquals((int)2, (int)this.context.getRoutes().size());
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedHeaderReceived("foo", (Object)"was wrapped");
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedHeaderReceived("foo", (Object)"was wrapped");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("foo", (Object)"was wrapped");
        this.getMockEndpoint("mock:response").expectedMessageCount(1);
        this.getMockEndpoint("mock:response").expectedHeaderReceived("foo", (Object)"policy finished execution");
        this.template.sendBody("direct:send", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MyPolicy foo = (MyPolicy)this.context.getRegistry().lookupByNameAndType("foo", MyPolicy.class);
        LoadRouteFromXmlWithPolicyTest.assertEquals((String)"Should only be invoked 1 time", (int)1, (int)foo.getInvoked());
    }

    public static class MyPolicy
    implements Policy {
        private final String name;
        private int invoked;

        public MyPolicy(String name) {
            this.name = name;
        }

        public void beforeWrap(RouteContext routeContext, ProcessorDefinition<?> definition) {
        }

        public Processor wrap(RouteContext routeContext, final Processor processor) {
            return new Processor(){

                public void process(Exchange exchange) throws Exception {
                    MyPolicy.this.invoked++;
                    exchange.getIn().setHeader(MyPolicy.this.name, (Object)"was wrapped");
                    processor.process(exchange);
                    exchange.getIn().setHeader(MyPolicy.this.name, (Object)"policy finished execution");
                }
            };
        }

        public int getInvoked() {
            return this.invoked;
        }
    }
}

