/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class StartingRoutesErrorReportedTest
extends ContextTestSupport {
    public void testInvalidFrom() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("direct:start?foo=bar").routeId("route1").to("mock:result");
                }
            });
            this.context.start();
            StartingRoutesErrorReportedTest.fail();
        }
        catch (FailedToCreateRouteException e) {
            StartingRoutesErrorReportedTest.assertTrue((boolean)e.getMessage().startsWith("Failed to create route route1: Route(route1)[[From[direct:start?foo=bar]] -> [To[mock:resul... because of"));
        }
    }

    public void testInvalidTo() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("direct:start").routeId("route2").to("direct:result?foo=bar");
                }
            });
            this.context.start();
            StartingRoutesErrorReportedTest.fail();
        }
        catch (FailedToCreateRouteException e) {
            StartingRoutesErrorReportedTest.assertTrue((boolean)e.getMessage().startsWith("Failed to create route route2 at: >>> To[direct:result?foo=bar] <<< in route: Route(route2)[[From[direct:start]] -> [To[direct:result?foo=... because of"));
        }
    }

    public void testInvalidBean() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ((RouteDefinition)this.from("direct:start").routeId("route3").to("mock:foo")).bean((Object)"");
                }
            });
            this.context.start();
            StartingRoutesErrorReportedTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException e) {
            StartingRoutesErrorReportedTest.assertTrue((boolean)e.getMessage().startsWith("Failed to create route route3 at: >>> Bean[ref:] <<< in route: Route(route3)[[From[direct:start]] -> [To[mock:foo], Bean[re... because of"));
        }
    }

    public void testUnavailableDataFormatOnClasspath() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("direct:start").routeId("route3").unmarshal().jaxb().log("Will never get here");
                }
            });
            this.context.start();
            StartingRoutesErrorReportedTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException e) {
            StartingRoutesErrorReportedTest.assertTrue((boolean)e.getMessage().contains("Ensure that the data format is valid and the associated Camel component is present on the classpath"));
        }
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

