/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;

public class AOPAroundFinallyTest
extends ContextTestSupport {
    public void testAOPAroundFinally() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello World"});
        ((ValueBuilder)this.getMockEndpoint("mock:after").message(0).body()).isEqualTo((Object)"Bye World");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        AOPAroundFinallyTest.assertEquals((String)"Bye World", (String)out);
        this.assertMockEndpointsSatisfied();
    }

    public void testAOPAroundFinallyWithException() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Kaboom"});
        ((ValueBuilder)this.getMockEndpoint("mock:after").message(0).body()).isEqualTo((Object)"Kaboom the World");
        try {
            this.template.requestBody("direct:start", (Object)"Kaboom", String.class);
            AOPAroundFinallyTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            AOPAroundFinallyTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            AOPAroundFinallyTest.assertEquals((String)"Damn", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").aop().aroundFinally("mock:before", "mock:after").choice().when(this.body().isEqualTo((Object)"Hello World")).transform((Expression)this.constant("Bye World"))).otherwise().transform((Expression)this.constant("Kaboom the World"))).throwException((Exception)new IllegalArgumentException("Damn"))).end().to("mock:result");
            }
        };
    }
}

