/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.LoopDefinition;
import org.apache.camel.processor.LoopTestProcessor;
import org.apache.camel.processor.async.MyAsyncComponent;

public class AsyncLoopTest
extends ContextTestSupport {
    private static final String BASE_PAYLOAD = "<Hello n='4'/>";
    MockEndpoint resultEndpoint;

    public void testCounterLoop() throws Exception {
        this.performLoopTest("direct:a", 8);
    }

    public void testExpressionLoop() throws Exception {
        this.performLoopTest("direct:b", 6);
    }

    public void testExpressionClauseLoop() throws Exception {
        this.performLoopTest("direct:c", 4);
    }

    public void testLoopAsBlock() throws Exception {
        MockEndpoint lastEndpoint = this.resolveMandatoryEndpoint("mock:last", MockEndpoint.class);
        lastEndpoint.expectedMessageCount(1);
        lastEndpoint.expectedBodiesReceived(new Object[]{BASE_PAYLOAD + new String(new char[2]).replace("\u0000", " Hello Camel")});
        this.performLoopTest("direct:d", 2);
        lastEndpoint.assertIsSatisfied();
    }

    public void testLoopWithInvalidExpression() throws Exception {
        try {
            this.performLoopTest("direct:b", 4, "invalid");
            AsyncLoopTest.fail((String)"Exception expected for invalid expression");
        }
        catch (RuntimeCamelException runtimeCamelException) {
            // empty catch block
        }
    }

    public void testLoopProperties() throws Exception {
        MockEndpoint lastEndpoint = this.resolveMandatoryEndpoint("mock:last", MockEndpoint.class);
        lastEndpoint.expectedMessageCount(1);
        lastEndpoint.expectedBodiesReceived(new Object[]{BASE_PAYLOAD + new String(new char[10]).replace("\u0000", " Hello Camel")});
        this.performLoopTest("direct:e", 10);
        lastEndpoint.assertIsSatisfied();
    }

    private void performLoopTest(String endpointUri, int expectedIterations, String header) throws InterruptedException {
        this.resultEndpoint.expectedMessageCount(expectedIterations);
        ArrayList<String> results = new ArrayList<String>(expectedIterations);
        for (int i = 0; i < expectedIterations; ++i) {
            results.add(BASE_PAYLOAD + new String(new char[i + 1]).replace("\u0000", " Hello Camel"));
        }
        this.resultEndpoint.expectedBodiesReceived(results);
        this.template.sendBodyAndHeader(endpointUri, (Object)BASE_PAYLOAD, "loop", (Object)header);
        this.resultEndpoint.assertIsSatisfied();
    }

    private void performLoopTest(String endpointUri, int expectedIterations) throws InterruptedException {
        this.performLoopTest(endpointUri, expectedIterations, "6");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        this.resultEndpoint.reset();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        final LoopTestProcessor loopTest = new LoopTestProcessor(10);
        return new RouteBuilder(){

            public void configure() {
                AsyncLoopTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((ExpressionNode)this.from("direct:a").loop(8).to("async:hello:camel?append=true")).to("mock:result");
                ((ExpressionNode)this.from("direct:b").loop((Expression)this.header("loop")).to("async:hello:camel?append=true")).to("mock:result");
                ((ExpressionNode)((LoopDefinition)this.from("direct:c").loop().xpath("/Hello/@n")).to("async:hello:camel?append=true")).to("mock:result");
                ((ExpressionNode)((ExpressionNode)this.from("direct:d").loop(2).to("async:hello:camel?append=true")).to("mock:result")).end().to("mock:last");
                ((ExpressionNode)((ExpressionNode)((ExpressionNode)this.from("direct:e").loop(10).to("async:hello:camel?append=true")).process(loopTest)).to("mock:result")).end().to("mock:last");
            }
        };
    }
}

