/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.RouteBuilder;

public class BeanInvocationThrowsExceptionTest
extends ContextTestSupport {
    public void testBeanInvocation() {
        int result = (Integer)this.template.sendBody("direct:input", ExchangePattern.InOut, (Object)"Hello London");
        BeanInvocationThrowsExceptionTest.assertEquals((int)1, (int)result);
    }

    public void testBeanInvocationFailure() {
        Exchange exchange = this.getMandatoryEndpoint("direct:input").createExchange(ExchangePattern.InOut);
        exchange.getIn().setBody((Object)"Hello Paris");
        Exchange out = this.template.send("direct:input", exchange);
        BeanInvocationThrowsExceptionTest.assertTrue((String)"Should be failed", (boolean)out.isFailed());
        BeanInvocationThrowsExceptionTest.assertTrue((String)"Should be IllegalArgumentException", (boolean)(out.getException() instanceof IllegalArgumentException));
        BeanInvocationThrowsExceptionTest.assertEquals((String)"Forced exception", (String)out.getException().getMessage());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:input").bean((Object)new ExceptionBean());
            }
        };
    }

    public static class ExceptionBean {
        public int doSomething(String request) throws Exception {
            if (request.equals("Hello London")) {
                return 1;
            }
            throw new IllegalArgumentException("Forced exception");
        }
    }
}

