/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.Context;
import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.util.jndi.JndiContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanRouteTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BeanRouteTest.class);
    protected MyBean myBean = new MyBean();

    public void testSendingMessageWithMethodNameHeader() throws Exception {
        String expectedBody = "Wobble";
        this.template.sendBodyAndHeader("direct:in", (Object)expectedBody, "CamelBeanMethodName", (Object)"read");
        BeanRouteTest.assertEquals((String)("bean received correct value for: " + this.myBean), (String)expectedBody, (String)this.myBean.body);
    }

    public void testSendingMessageWithMethodNameHeaderWithMoreVerboseCoe() throws Exception {
        String expectedBody = "Wibble";
        this.template.send("direct:in", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody((Object)"Wibble");
                in.setHeader("CamelBeanMethodName", (Object)"read");
            }
        });
        BeanRouteTest.assertEquals((String)"bean received correct value", (String)"Wibble", (String)this.myBean.body);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Object lookedUpBean = this.context.getRegistry().lookupByName("myBean");
        BeanRouteTest.assertSame((String)"Lookup of 'myBean' should return same object!", (Object)this.myBean, (Object)lookedUpBean);
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("myBean", (Object)this.myBean);
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").bean((Object)"myBean");
            }
        };
    }

    public static class MyBean {
        private static AtomicInteger counter = new AtomicInteger(0);
        public String body;
        private int id = counter.incrementAndGet();

        public String toString() {
            return "MyBean:" + this.id;
        }

        public void read(String body) {
            this.body = body;
            LOG.info("read() method on " + this + " with body: " + body);
        }

        public void wrongMethod(String body) {
            TestCase.fail((String)("wrongMethod() called with: " + body));
        }
    }
}

