/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExpressionNode;

public class ChoiceAsyncTest
extends ContextTestSupport {
    protected MockEndpoint x;
    protected MockEndpoint y;
    protected MockEndpoint z;
    protected MockEndpoint end;

    public void testSendToFirstWhen() throws Exception {
        String body = "<one/>";
        this.x.expectedBodiesReceived(new Object[]{body});
        this.end.expectedBodiesReceived(new Object[]{body});
        MockEndpoint.expectsMessageCount((int)0, (MockEndpoint[])new MockEndpoint[]{this.y, this.z});
        this.sendMessage("bar", body);
        this.assertMockEndpointsSatisfied();
    }

    public void testSendToSecondWhen() throws Exception {
        String body = "<two/>";
        this.y.expectedBodiesReceived(new Object[]{body});
        this.end.expectedBodiesReceived(new Object[]{body});
        MockEndpoint.expectsMessageCount((int)0, (MockEndpoint[])new MockEndpoint[]{this.x, this.z});
        this.sendMessage("cheese", body);
        this.assertMockEndpointsSatisfied();
    }

    public void testSendToOtherwiseClause() throws Exception {
        String body = "<three/>";
        this.z.expectedBodiesReceived(new Object[]{body});
        this.end.expectedBodiesReceived(new Object[]{body});
        MockEndpoint.expectsMessageCount((int)0, (MockEndpoint[])new MockEndpoint[]{this.x, this.y});
        this.sendMessage("somethingUndefined", body);
        this.assertMockEndpointsSatisfied();
    }

    protected void sendMessage(Object headerValue, Object body) throws Exception {
        this.template.sendBodyAndHeader("direct:start", body, "foo", headerValue);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.y = this.getMockEndpoint("mock:y");
        this.z = this.getMockEndpoint("mock:z");
        this.end = this.getMockEndpoint("mock:end");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((ExpressionNode)((ChoiceDefinition)((ExpressionNode)((ChoiceDefinition)this.from("direct:start").choice().when().xpath("$foo = 'bar'")).delay(10L).asyncDelayed().to("mock:x")).endChoice().when().xpath("$foo = 'cheese'")).delay(10L).asyncDelayed().to("mock:y")).endChoice().otherwise().delay(10L).asyncDelayed().to("mock:z")).endChoice().end().to("mock:end");
            }
        };
    }
}

