/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.HashMap;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;

public class ChoiceCompoundPredicateTest
extends ContextTestSupport {
    public void testGuest() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:guest");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testUser() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:user");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "username", (Object)"goofy");
        this.assertMockEndpointsSatisfied();
    }

    public void testAdmin() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:admin");
        mock.expectedMessageCount(1);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("username", "donald");
        headers.put("admin", "true");
        this.template.sendBodyAndHeaders("direct:start", (Object)"Hello World", headers);
        this.assertMockEndpointsSatisfied();
    }

    public void testGod() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:god");
        mock.expectedMessageCount(1);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("username", "pluto");
        headers.put("admin", "true");
        headers.put("type", "god");
        this.template.sendBodyAndHeaders("direct:start", (Object)"Hello World", headers);
        this.assertMockEndpointsSatisfied();
    }

    public void testRiderGod() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:god");
        mock.expectedMessageCount(1);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("username", "Camel");
        headers.put("admin", "true");
        this.template.sendBodyAndHeaders("direct:start", (Object)"Hello Camel Rider", headers);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                Predicate user = this.header("username").isNotNull();
                Predicate admin = PredicateBuilder.and((Predicate)user, (Predicate)this.header("admin").isEqualTo((Object)"true"));
                Predicate god = PredicateBuilder.and((Predicate)admin, (Predicate)PredicateBuilder.or((Predicate)this.body().contains((Object)"Camel Rider"), (Predicate)this.header("type").isEqualTo((Object)"god")));
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(god).to("mock:god")).when(admin).to("mock:admin")).when(user).to("mock:user")).otherwise().to("mock:guest")).end();
            }
        };
    }
}

