/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;

public class ChoiceTest
extends ContextTestSupport {
    protected MockEndpoint x;
    protected MockEndpoint y;
    protected MockEndpoint z;
    protected MockEndpoint end;

    public void testSendToFirstWhen() throws Exception {
        String body = "<one/>";
        this.x.expectedBodiesReceived(new Object[]{body});
        this.end.expectedBodiesReceived(new Object[]{body});
        MockEndpoint.expectsMessageCount((int)0, (MockEndpoint[])new MockEndpoint[]{this.y, this.z});
        this.sendMessage("bar", body);
        this.assertMockEndpointsSatisfied();
    }

    public void testSendToSecondWhen() throws Exception {
        String body = "<two/>";
        this.y.expectedBodiesReceived(new Object[]{body});
        this.end.expectedBodiesReceived(new Object[]{body});
        MockEndpoint.expectsMessageCount((int)0, (MockEndpoint[])new MockEndpoint[]{this.x, this.z});
        this.sendMessage("cheese", body);
        this.assertMockEndpointsSatisfied();
    }

    public void testSendToOtherwiseClause() throws Exception {
        String body = "<three/>";
        this.z.expectedBodiesReceived(new Object[]{body});
        this.end.expectedBodiesReceived(new Object[]{body});
        MockEndpoint.expectsMessageCount((int)0, (MockEndpoint[])new MockEndpoint[]{this.x, this.y});
        this.sendMessage("somethingUndefined", body);
        this.assertMockEndpointsSatisfied();
    }

    protected void sendMessage(Object headerValue, Object body) throws Exception {
        this.template.sendBodyAndHeader("direct:start", body, "foo", headerValue);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.y = this.getMockEndpoint("mock:y");
        this.z = this.getMockEndpoint("mock:z");
        this.end = this.getMockEndpoint("mock:end");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when().xpath("$foo = 'bar'")).to("mock:x")).when().xpath("$foo = 'cheese'")).to("mock:y")).otherwise().to("mock:z")).end().to("mock:end");
            }
        };
    }
}

