/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class DeadLetterChannelOnRedeliveryTest
extends ContextTestSupport {
    static int counter;

    public void testOnExceptionAlterMessageBeforeRedelivery() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World3"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testOnExceptionAlterMessageWithHeadersBeforeRedelivery() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World3"});
        mock.expectedHeaderReceived("foo", (Object)"123");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        counter = 0;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error").maximumRedeliveries(5).onRedelivery((Processor)new MyRedeliverProcessor()).redeliveryDelay(0L));
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        if (++counter <= 3) {
                            throw new IllegalArgumentException("Forced by unit test");
                        }
                    }
                })).to("mock:result");
            }
        };
    }

    public class MyRedeliverProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            String body = (String)exchange.getIn().getBody(String.class);
            int count = (Integer)exchange.getIn().getHeader("CamelRedeliveryCounter", Integer.class);
            exchange.getIn().setBody((Object)(body + count));
            int max = (Integer)exchange.getIn().getHeader("CamelRedeliveryMaxCounter", Integer.class);
            TestCase.assertEquals((int)5, (int)max);
        }
    }
}

