/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class DeadLetterChannelRedeliverWithDelayBlockingTest
extends ContextTestSupport {
    private static int counter;

    public void testRedeliverWithDelay() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Message 2", "Message 1"});
        mock.expectedHeaderReceived("foo", (Object)"bar");
        ((ValueBuilder)mock.message(0).header("CamelRedelivered")).isNull();
        ((ValueBuilder)mock.message(1).header("CamelRedelivered")).isEqualTo((Object)true);
        Callable<Object> task1 = Executors.callable(new Runnable(){

            @Override
            public void run() {
                DeadLetterChannelRedeliverWithDelayBlockingTest.this.template.sendBody("direct:start", (Object)"Message 1");
            }
        });
        Callable<Object> task2 = Executors.callable(new Runnable(){

            @Override
            public void run() {
                DeadLetterChannelRedeliverWithDelayBlockingTest.this.template.sendBody("direct:start", (Object)"Message 2");
            }
        });
        Executors.newCachedThreadPool().submit(task1);
        Thread.sleep(100L);
        Executors.newCachedThreadPool().submit(task2);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead").redeliveryDelay(250L).maximumRedeliveries(3).logStackTrace(false));
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if ("Message 1".equals(body) && counter++ < 2) {
                            throw new IllegalArgumentException("Damn");
                        }
                        exchange.getIn().setHeader("foo", (Object)"bar");
                    }
                })).to("mock:result");
            }
        };
    }
}

