/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;

public class DefaultErrorHandlerRedeliveryTest
extends ContextTestSupport {
    private static int counter;

    public void testRedeliveryTest() throws Exception {
        counter = 0;
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            DefaultErrorHandlerRedeliveryTest.fail((String)"Should have thrown exception");
        }
        catch (RuntimeCamelException runtimeCamelException) {
            // empty catch block
        }
        DefaultErrorHandlerRedeliveryTest.assertEquals((int)3, (int)counter);
    }

    public void testNoRedeliveriesTest() throws Exception {
        counter = 0;
        try {
            this.template.sendBody("direct:no", (Object)"Hello World");
            DefaultErrorHandlerRedeliveryTest.fail((String)"Should have thrown exception");
        }
        catch (RuntimeCamelException runtimeCamelException) {
            // empty catch block
        }
        DefaultErrorHandlerRedeliveryTest.assertEquals((int)1, (int)counter);
    }

    public void testOneRedeliveryTest() throws Exception {
        counter = 0;
        try {
            this.template.sendBody("direct:one", (Object)"Hello World");
            DefaultErrorHandlerRedeliveryTest.fail((String)"Should have thrown exception");
        }
        catch (RuntimeCamelException runtimeCamelException) {
            // empty catch block
        }
        DefaultErrorHandlerRedeliveryTest.assertEquals((int)2, (int)counter);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().maximumRedeliveries(2)).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        counter++;
                        throw new Exception("Forced exception by unit test");
                    }
                });
                this.from("direct:no").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        counter++;
                        throw new Exception("Forced exception by unit test");
                    }
                });
                this.from("direct:one").errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().maximumRedeliveries(1)).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        counter++;
                        throw new Exception("Forced exception by unit test");
                    }
                });
            }
        };
    }
}

