/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.PipelineDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SendDefinition;

public class DualPipelineTest
extends ContextTestSupport {
    public void testDualPipeline() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"After A"});
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:d").expectedBodiesReceived(new Object[]{"After C"});
        this.getMockEndpoint("mock:e").expectedBodiesReceived(new Object[]{"After C"});
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MulticastDefinition mc = DualPipelineTest.assertIsInstanceOf(MulticastDefinition.class, ((RouteDefinition)this.context.getRouteDefinitions().get(0)).getOutputs().get(0));
        PipelineDefinition pd1 = DualPipelineTest.assertIsInstanceOf(PipelineDefinition.class, mc.getOutputs().get(0));
        PipelineDefinition pd2 = DualPipelineTest.assertIsInstanceOf(PipelineDefinition.class, mc.getOutputs().get(1));
        DualPipelineTest.assertEquals((int)3, (int)pd1.getOutputs().size());
        DualPipelineTest.assertEquals((int)4, (int)pd2.getOutputs().size());
        SendDefinition send1 = DualPipelineTest.assertIsInstanceOf(SendDefinition.class, pd1.getOutputs().get(2));
        DualPipelineTest.assertEquals((String)"mock:b", (String)send1.getUri());
        SendDefinition send2 = DualPipelineTest.assertIsInstanceOf(SendDefinition.class, pd2.getOutputs().get(3));
        DualPipelineTest.assertEquals((String)"mock:e", (String)send2.getUri());
        SendDefinition send = DualPipelineTest.assertIsInstanceOf(SendDefinition.class, ((RouteDefinition)this.context.getRouteDefinitions().get(0)).getOutputs().get(1));
        DualPipelineTest.assertEquals((String)"mock:result", (String)send.getUri());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)this.from("direct:start").multicast().pipeline().to("mock:a")).setBody((Expression)this.constant("After A"))).to("mock:b")).end().pipeline().to("mock:c")).setBody((Expression)this.constant("After C"))).to("mock:d")).to("mock:e")).end().end().to("mock:result");
            }
        };
    }
}

