/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.idempotent.MemoryIdempotentRepository;
import org.apache.camel.spi.ExchangeIdempotentRepository;
import org.apache.camel.spi.IdempotentRepository;

public class ExchangeIdempotentConsumerTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;
    private MyIdempotentRepo repo = new MyIdempotentRepo();

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testDuplicateMessagesAreFilteredOut() throws Exception {
        ExchangeIdempotentConsumerTest.assertEquals((int)0, (int)this.repo.getExchange().size());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), (IdempotentRepository)ExchangeIdempotentConsumerTest.this.repo).to("mock:result");
            }
        });
        this.context.start();
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"one", "two", "three"});
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("3", "three");
        this.assertMockEndpointsSatisfied();
        ExchangeIdempotentConsumerTest.assertEquals((int)6, (int)this.repo.getExchange().size());
        for (Exchange exchange : this.resultEndpoint.getExchanges()) {
            ExchangeIdempotentConsumerTest.assertTrue((String)"Should contain the exchange", (boolean)this.repo.getExchange().contains(exchange.getExchangeId()));
        }
    }

    protected void sendMessage(final Object messageId, final Object body) {
        this.template.send(this.startEndpoint, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                in.setHeader("messageId", messageId);
            }
        });
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.startEndpoint = this.resolveMandatoryEndpoint("direct:start");
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    private final class MyIdempotentRepo
    implements ExchangeIdempotentRepository<String> {
        private IdempotentRepository<String> delegate;
        private Set<String> exchanges = new LinkedHashSet<String>();

        private MyIdempotentRepo() {
            this.delegate = MemoryIdempotentRepository.memoryIdempotentRepository((int)200);
        }

        public boolean add(Exchange exchange, String key) {
            this.exchanges.add(exchange.getExchangeId());
            return this.delegate.add((Object)key);
        }

        public boolean contains(Exchange exchange, String key) {
            this.exchanges.add(exchange.getExchangeId());
            return this.delegate.contains((Object)key);
        }

        public boolean remove(Exchange exchange, String key) {
            this.exchanges.add(exchange.getExchangeId());
            return this.delegate.remove((Object)key);
        }

        public boolean confirm(Exchange exchange, String key) {
            this.exchanges.add(exchange.getExchangeId());
            return this.delegate.confirm((Object)key);
        }

        public void clear() {
            this.delegate.clear();
        }

        public boolean add(String key) {
            throw new UnsupportedOperationException("Should not be called");
        }

        public boolean contains(String key) {
            throw new UnsupportedOperationException("Should not be called");
        }

        public boolean remove(String key) {
            throw new UnsupportedOperationException("Should not be called");
        }

        public boolean confirm(String key) {
            throw new UnsupportedOperationException("Should not be called");
        }

        public Set<String> getExchange() {
            return this.exchanges;
        }

        public void start() throws Exception {
        }

        public void stop() throws Exception {
        }
    }
}

