/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class FailoverRoundRobinStickyTest
extends ContextTestSupport {
    public void testFailoverRoundRobinSticky() throws Exception {
        this.getMockEndpoint("mock:bad").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:bad2").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:good").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:good2").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        this.getMockEndpoint("mock:bad").expectedMessageCount(0);
        this.getMockEndpoint("mock:bad2").expectedMessageCount(0);
        this.getMockEndpoint("mock:good").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:good2").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").loadBalance().failover(-1, false, true, true, new Class[0]).to(new String[]{"direct:bad", "direct:bad2", "direct:good", "direct:good2"});
                ((RouteDefinition)this.from("direct:bad").to("mock:bad")).throwException((Exception)new IllegalArgumentException("Damn"));
                ((RouteDefinition)this.from("direct:bad2").to("mock:bad2")).throwException((Exception)new IllegalArgumentException("Damn Again"));
                this.from("direct:good").to("mock:good");
                this.from("direct:good2").to("mock:good2");
            }
        };
    }
}

