/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.idempotent.FileIdempotentRepository;
import org.apache.camel.spi.IdempotentRepository;

public class FileIdempotentClearTest
extends ContextTestSupport {
    private File store = new File("target/idempotentfilestore.dat");
    private IdempotentRepository<String> repo;

    @Override
    protected void setUp() throws Exception {
        if (this.store.exists()) {
            this.store.delete();
        }
        this.repo = FileIdempotentRepository.fileIdempotentRepository((File)this.store);
        super.setUp();
    }

    public void testClear() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Foo", "Bar"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Foo", "messageId", (Object)"A");
        this.template.sendBodyAndHeader("direct:start", (Object)"Camel rocks", "messageId", (Object)"A");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bar", "messageId", (Object)"B");
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Camel rocks"});
        this.repo.clear();
        FileIdempotentClearTest.assertFalse((boolean)this.repo.contains((Object)"A"));
        FileIdempotentClearTest.assertFalse((boolean)this.repo.contains((Object)"B"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), FileIdempotentClearTest.this.repo).to("mock:result");
            }
        };
    }
}

