/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.File;
import java.util.UUID;
import org.apache.camel.processor.idempotent.FileIdempotentRepository;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.util.FileUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class FileIdempotentConsumerCreateRepoTest
extends Assert {
    File store;

    @Test
    public void shouldCreateParentOfRepositoryFileStore() throws Exception {
        File parentDirectory = new File("target/repositoryParent_" + UUID.randomUUID());
        this.store = new File(parentDirectory, "store");
        this.assertStoreExists(this.store);
    }

    @Test
    public void shouldUseCurrentDirIfHasNoParentFile() throws Exception {
        String storeFileName = "store" + UUID.randomUUID();
        this.store = new File(storeFileName);
        this.assertStoreExists(this.store);
    }

    private void assertStoreExists(File store) throws Exception {
        IdempotentRepository repo = FileIdempotentRepository.fileIdempotentRepository((File)store);
        repo.start();
        repo.add((Object)"anyKey");
        FileIdempotentConsumerCreateRepoTest.assertTrue((boolean)store.exists());
        repo.stop();
    }

    @After
    public void after() {
        FileUtil.deleteFile((File)this.store);
    }
}

