/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.support.ServiceSupport;

public class OnCompletionShutdownProcessorTest
extends ContextTestSupport {
    private MyProcessor processor = new MyProcessor();

    public void testSynchronizeComplete() throws Exception {
        OnCompletionShutdownProcessorTest.assertEquals((String)"Started", (String)this.processor.getStatus().name());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        OnCompletionShutdownProcessorTest.assertEquals((String)"Stopped", (String)this.processor.getStatus().name());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.onCompletion().process((Processor)OnCompletionShutdownProcessorTest.this.processor);
                this.from("direct:start").to("mock:result");
            }
        };
    }

    public static class MyProcessor
    extends ServiceSupport
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            exchange.getIn().setBody((Object)"Bye World");
        }

        protected void doStart() throws Exception {
        }

        protected void doStop() throws Exception {
        }
    }
}

