/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnCompletionDefinition;

public class OnCompletionTest
extends ContextTestSupport {
    public void testSynchronizeComplete() throws Exception {
        this.getMockEndpoint("mock:sync").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:sync").expectedPropertyReceived("CamelOnCompletion", (Object)true);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testSynchronizeFailure() throws Exception {
        this.getMockEndpoint("mock:sync").expectedMessageCount(1);
        this.getMockEndpoint("mock:sync").expectedPropertyReceived("CamelOnCompletion", (Object)true);
        ((ValueBuilder)this.getMockEndpoint("mock:sync").message(0).exchangeProperty("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Kabom");
            OnCompletionTest.fail((String)"Should throw exception");
        }
        catch (CamelExecutionException e) {
            OnCompletionTest.assertEquals((String)"Kabom", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnCompletionDefinition)((OnCompletionDefinition)this.from("direct:start").onCompletion().to("log:sync")).to("mock:sync")).end().process((Processor)new MyProcessor()).to("mock:result");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            if ("Kabom".equals(exchange.getIn().getBody())) {
                throw new IllegalArgumentException("Kabom");
            }
            exchange.getIn().setBody((Object)"Bye World");
        }
    }
}

