/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class PipelineConcurrentTest
extends ContextTestSupport {
    private String uri = "seda:in?size=2000&concurrentConsumers=10";

    public void testConcurrentPipeline() throws Exception {
        int total = 200;
        final int group = total / 20;
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(total);
        ExecutorService executor = Executors.newFixedThreadPool(20);
        int i = 0;
        while (i < 20) {
            final int threadCount = i++;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    int start = threadCount * group;
                    for (int i = 0; i < group; ++i) {
                        try {
                            Thread.sleep(new Random().nextInt(10));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        PipelineConcurrentTest.this.template.sendBody(PipelineConcurrentTest.this.uri, (Object)("" + (start + i)));
                    }
                }
            });
        }
        mock.assertIsSatisfied();
        mock.expectsNoDuplicates((Expression)PipelineConcurrentTest.body());
        executor.shutdown();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.noErrorHandler());
                this.from(PipelineConcurrentTest.this.uri).pipeline(new String[]{"direct:do", "mock:result"});
                this.from("direct:do").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String body = (String)exchange.getIn().getBody(String.class);
                        exchange.getOut().setBody((Object)("Bye " + body));
                    }
                });
            }
        };
    }
}

