/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;

public class RecipientListParallelTest
extends ContextTestSupport {
    public void testRecipientListParallel() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"c", "b", "a"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"direct:a,direct:b,direct:c");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").recipientList((Expression)this.header("foo")).parallelProcessing();
                ((ExpressionNode)this.from("direct:a").delay(1000L).transform((Expression)this.constant("a"))).to("mock:result");
                ((ExpressionNode)this.from("direct:b").delay(500L).transform((Expression)this.constant("b"))).to("mock:result");
                ((RouteDefinition)this.from("direct:c").transform((Expression)this.constant("c"))).to("mock:result");
            }
        };
    }
}

