/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.StopWatch;

public class RedeliveryDeadLetterErrorHandlerNoRedeliveryOnShutdownTest
extends ContextTestSupport {
    private final AtomicInteger counter = new AtomicInteger();

    public void testRedeliveryErrorHandlerNoRedeliveryOnShutdown() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:deadLetter").expectedMessageCount(1);
        this.getMockEndpoint("mock:deadLetter").setResultWaitTime(25000L);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.getMockEndpoint("mock:foo").assertIsSatisfied();
        StopWatch watch = new StopWatch();
        Thread.sleep(3000L);
        this.log.info("==== stopping route foo ====");
        this.context.stopRoute("foo");
        watch.stop();
        this.getMockEndpoint("mock:deadLetter").assertIsSatisfied();
        this.log.info("OnRedelivery processor counter {}", (Object)this.counter.get());
        RedeliveryDeadLetterErrorHandlerNoRedeliveryOnShutdownTest.assertTrue((String)("Should stop route faster, was " + watch.taken()), (watch.taken() < 7000L ? 1 : 0) != 0);
        RedeliveryDeadLetterErrorHandlerNoRedeliveryOnShutdownTest.assertTrue((String)("Redelivery counter should be >= 2 and < 12, was: " + this.counter.get()), (this.counter.get() >= 2 && this.counter.get() < 12 ? 1 : 0) != 0);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:deadLetter").allowRedeliveryWhileStopping(false).onRedelivery((Processor)new MyRedeliverProcessor()).maximumRedeliveries(20).redeliveryDelay(1000L).retryAttemptedLogLevel(LoggingLevel.INFO));
                ((RouteDefinition)this.from("seda:foo").routeId("foo").to("mock:foo")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }

    private final class MyRedeliverProcessor
    implements Processor {
        private MyRedeliverProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            RedeliveryDeadLetterErrorHandlerNoRedeliveryOnShutdownTest.this.counter.incrementAndGet();
        }
    }
}

