/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.StopWatch;

public class RedeliveryErrorHandlerNoRedeliveryOnShutdownTest
extends ContextTestSupport {
    public void testRedeliveryErrorHandlerNoRedeliveryOnShutdown() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        StopWatch watch = new StopWatch();
        this.context.stopRoute("foo");
        watch.stop();
        RedeliveryErrorHandlerNoRedeliveryOnShutdownTest.assertTrue((String)("Should stop route faster, was " + watch.taken()), (watch.taken() < 4000L ? 1 : 0) != 0);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.defaultErrorHandler().allowRedeliveryWhileStopping(false).maximumRedeliveries(20).redeliveryDelay(1000L).retryAttemptedLogLevel(LoggingLevel.INFO));
                ((RouteDefinition)this.from("seda:foo").routeId("foo").to("mock:foo")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }
}

