/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;

public class RemovePropertiesWithoutExclusionTest
extends ContextTestSupport {
    private MockEndpoint end;
    private MockEndpoint mid;
    private String propertyName = "foo";
    private String expectedPropertyValue = "bar";
    private String propertyName1 = "fee";
    private String expectedPropertyValue1 = "bar1";
    private String pattern = "f*";

    public void testSetExchangePropertiesMidRouteThenRemoveWithPattern() throws Exception {
        this.mid.expectedMessageCount(1);
        this.end.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"message");
        this.assertMockEndpointsSatisfied();
        List midExchanges = this.mid.getExchanges();
        Exchange midExchange = (Exchange)midExchanges.get(0);
        String actualPropertyValue = (String)midExchange.getProperty(this.propertyName, String.class);
        String actualPropertyValue1 = (String)midExchange.getProperty(this.propertyName1, String.class);
        RemovePropertiesWithoutExclusionTest.assertEquals((String)this.expectedPropertyValue, (String)actualPropertyValue);
        RemovePropertiesWithoutExclusionTest.assertEquals((String)this.expectedPropertyValue1, (String)actualPropertyValue1);
        List endExchanges = this.end.getExchanges();
        Exchange endExchange = (Exchange)endExchanges.get(0);
        RemovePropertiesWithoutExclusionTest.assertNull((Object)endExchange.getProperty(this.propertyName, String.class));
        RemovePropertiesWithoutExclusionTest.assertNull((Object)endExchange.getProperty(this.propertyName1, String.class));
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.end = this.getMockEndpoint("mock:end");
        this.mid = this.getMockEndpoint("mock:mid");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((ProcessorDefinition)((ProcessorDefinition)this.from("direct:start").setProperty(RemovePropertiesWithoutExclusionTest.this.propertyName).constant((Object)RemovePropertiesWithoutExclusionTest.this.expectedPropertyValue)).setProperty(RemovePropertiesWithoutExclusionTest.this.propertyName1).constant((Object)RemovePropertiesWithoutExclusionTest.this.expectedPropertyValue1)).to("mock:mid")).removeProperties(RemovePropertiesWithoutExclusionTest.this.pattern)).to("mock:end");
            }
        };
    }
}

