/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.RouteStartupOrder;

public class RouteShutdownReverseOrderTest
extends ContextTestSupport {
    public void testRouteShutdownReverseOrder() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:bar", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        DefaultCamelContext dcc = (DefaultCamelContext)this.context;
        List order = dcc.getRouteStartupOrder();
        RouteShutdownReverseOrderTest.assertEquals((int)2, (int)order.size());
        RouteShutdownReverseOrderTest.assertEquals((String)"direct://bar", (String)((RouteStartupOrder)order.get(0)).getRoute().getEndpoint().getEndpointUri());
        RouteShutdownReverseOrderTest.assertEquals((String)"direct://foo", (String)((RouteStartupOrder)order.get(1)).getRoute().getEndpoint().getEndpointUri());
        this.context.stop();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:foo").startupOrder(2).routeId("foo").to("mock:result");
                this.from("direct:bar").startupOrder(1).routeId("bar").to("direct:foo");
            }
        };
    }
}

