/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;

public class SetPropertyTest
extends ContextTestSupport {
    private MockEndpoint end;
    private String propertyName = "foo";
    private String expectedPropertyValue = "bar";

    public void testSetExchangePropertyMidRoute() throws Exception {
        this.end.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<blah/>");
        this.assertMockEndpointsSatisfied();
        List exchanges = this.end.getExchanges();
        Exchange exchange = (Exchange)exchanges.get(0);
        String actualPropertyValue = (String)exchange.getProperty(this.propertyName, String.class);
        SetPropertyTest.assertEquals((String)this.expectedPropertyValue, (String)actualPropertyValue);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.end = this.getMockEndpoint("mock:end");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").setProperty(SetPropertyTest.this.propertyName).constant((Object)SetPropertyTest.this.expectedPropertyValue)).to("mock:end");
            }
        };
    }
}

