/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.mock.MockEndpoint;

public class ShutdownNotDeferTest
extends ContextTestSupport {
    private static final AtomicBoolean CONSUMER_SUSPENDED = new AtomicBoolean();

    @Override
    protected void setUp() throws Exception {
        ShutdownNotDeferTest.deleteDirectory("target/deferred");
        super.setUp();
    }

    public void testShutdownNotDeferred() throws Exception {
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMinimumMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"A");
        this.template.sendBody("seda:foo", (Object)"B");
        this.template.sendBody("seda:foo", (Object)"C");
        this.template.sendBody("seda:foo", (Object)"D");
        this.template.sendBody("seda:foo", (Object)"E");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        ShutdownNotDeferTest.assertTrue((String)"Should have been suspended", (boolean)CONSUMER_SUSPENDED.get());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:foo").startupOrder(1).to("file://target/deferred");
                MyDeferFileEndpoint defer = new MyDeferFileEndpoint("file://target/deferred", this.getContext().getComponent("file"));
                defer.setFile(new File("target/deferred"));
                this.from((Endpoint)defer).startupOrder(2).shutdownRoute(ShutdownRoute.Default).to("mock:bar");
            }
        };
    }

    private static final class MyDeferFileEndpoint
    extends FileEndpoint {
        private MyDeferFileEndpoint(String endpointUri, Component component) {
            super(endpointUri, component);
        }

        protected FileConsumer newFileConsumer(Processor processor, GenericFileOperations<File> operations) {
            return new FileConsumer(this, processor, operations){

                protected void doSuspend() throws Exception {
                    CONSUMER_SUSPENDED.set(true);
                    super.doSuspend();
                }
            };
        }
    }
}

