/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.SplitDefinition;

public class SplitGroupWrappedMultiXmlTokenTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        SplitGroupWrappedMultiXmlTokenTest.deleteDirectory("target/pair");
        super.setUp();
    }

    public void testTokenXMLPairGroup() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedMessageCount(3);
        ((ValueBuilder)mock.message(0).body()).isEqualTo((Object)"<?xml version=\"1.0\"?>\n<orders xmlns=\"http:acme.com\">\n  <order id=\"1\">Camel in Action</order><order id=\"2\">ActiveMQ in Action</order></orders>");
        ((ValueBuilder)mock.message(1).body()).isEqualTo((Object)"<?xml version=\"1.0\"?>\n<orders xmlns=\"http:acme.com\">\n  <order id=\"3\">Spring in Action</order><order id=\"4\">Scala in Action</order></orders>");
        ((ValueBuilder)mock.message(2).body()).isEqualTo((Object)"<?xml version=\"1.0\"?>\n<orders xmlns=\"http:acme.com\">\n  <order id=\"5\">Groovy in Action</order></orders>");
        String body = this.createBody();
        this.template.sendBodyAndHeader("file:target/pair", (Object)body, "CamelFileName", (Object)"orders.xml");
        this.assertMockEndpointsSatisfied();
    }

    protected String createBody() {
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\"?>\n");
        sb.append("<orders xmlns=\"http:acme.com\">\n");
        sb.append("  <order id=\"1\">Camel in Action</order>\n");
        sb.append("  <order id=\"2\">ActiveMQ in Action</order>\n");
        sb.append("  <order id=\"3\">Spring in Action</order>\n");
        sb.append("  <order id=\"4\">Scala in Action</order>\n");
        sb.append("  <order id=\"5\">Groovy in Action</order>\n");
        sb.append("</orders>");
        return sb.toString();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){
            Namespaces ns = new Namespaces("", "http:acme.com");

            public void configure() throws Exception {
                ((ExpressionNode)((SplitDefinition)this.from("file:target/pair").split().xtokenize("//order", 'w', this.ns, 2)).to("log:split")).to("mock:split");
            }
        };
    }
}

