/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.SplitDefinition;

public class SplitTokenizerGroupTest
extends ContextTestSupport {
    public void testSplitTokenizerA() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"Claus,James", "Willem"});
        this.template.sendBody("direct:a", (Object)"Claus,James,Willem");
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitTokenizerB() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceived(new Object[]{"James,Willem"});
        this.template.sendBody("direct:b", (Object)"Claus,James,Willem".getBytes());
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((SplitDefinition)this.from("direct:a").split().tokenize(",", 2)).to("mock:split");
                this.from("direct:b").split((Expression)this.bodyAs(String.class).tokenize(",", 2, true)).to("mock:split");
            }
        };
    }
}

