/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Header;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.SplitDefinition;

public class SplitterPojoTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("mySplitterBean", (Object)new MySplitterBean());
        return jndi;
    }

    public void testSplitBodyWithPojoBean() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"James", "Jonathan", "Hadrian", "Claus", "Willem"});
        this.template.sendBody("direct:body", (Object)"James,Jonathan,Hadrian,Claus,Willem");
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitMessageWithPojoBean() throws Exception {
        String[] users = new String[]{"James", "Jonathan", "Hadrian", "Claus", "Willem"};
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.reset();
        mock.expectedMessageCount(5);
        this.template.sendBodyAndHeader("direct:message", (Object)"Test Body Message", "user", (Object)"James,Jonathan,Hadrian,Claus,Willem");
        int i = 0;
        for (Exchange exchange : mock.getExchanges()) {
            SplitterPojoTest.assertEquals((String)"We got a wrong body ", (Object)"Test Body Message", (Object)exchange.getIn().getBody());
            SplitterPojoTest.assertEquals((String)"We got a wrong header ", (Object)users[i], (Object)exchange.getIn().getHeader("user"));
            ++i;
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((SplitDefinition)this.from("direct:body").split().method("mySplitterBean", "splitBody")).to("mock:result");
                ((SplitDefinition)this.from("direct:message").split().method("mySplitterBean", "splitMessage")).to("mock:result");
            }
        };
    }

    public class MySplitterBean {
        public List<String> splitBody(String body) {
            String[] parts;
            ArrayList<String> answer = new ArrayList<String>();
            for (String part : parts = body.split(",")) {
                answer.add(part);
            }
            return answer;
        }

        public List<Message> splitMessage(@Header(value="user") String header, @Body String body) {
            String[] parts;
            ArrayList<Message> answer = new ArrayList<Message>();
            for (String part : parts = header.split(",")) {
                DefaultMessage message = new DefaultMessage();
                message.setHeader("user", (Object)part);
                message.setBody((Object)body);
                answer.add((Message)message);
            }
            return answer;
        }
    }
}

