/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;

public class ThreadsMaxQueueSizeTest
extends ContextTestSupport {
    public void testThreadsMaxQueueSize() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testThreadsMaxQueueSizeBuilder() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").threads(5, 10).maxQueueSize(2000).to("mock:result");
                this.from("direct:foo").threads().poolSize(5).maxPoolSize(10).maxQueueSize(2000).threadName("myPool").to("mock:result");
            }
        };
    }
}

