/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.ThrottlingInflightRoutePolicy;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;

public class ThrottlingInflightRoutePolicyTest
extends ContextTestSupport {
    private String url = "seda:foo?concurrentConsumers=20";
    private int size = 100;

    public void testThrottlingRoutePolicy() throws Exception {
        this.getMockEndpoint("mock:result").expectedMinimumMessageCount(this.size - 10);
        for (int i = 0; i < this.size; ++i) {
            this.template.sendBody(this.url, (Object)("Message " + i));
            Thread.sleep(3L);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ThrottlingInflightRoutePolicy policy = new ThrottlingInflightRoutePolicy();
                policy.setMaxInflightExchanges(10);
                ((RouteDefinition)this.from(ThrottlingInflightRoutePolicyTest.this.url).routePolicy(new RoutePolicy[]{policy}).to("log:foo?groupSize=10")).to("mock:result");
            }
        };
    }
}

