/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;

public class TransformBeanExceptionTest
extends ContextTestSupport {
    public void testTransformBeanException() throws Exception {
        this.getMockEndpoint("mock:dead").expectedBodiesReceived(new Object[]{"Hello World", "Bye World", "Hi World", "Hi Camel", "Bye Camel"});
        this.template.sendBody("direct:transform", (Object)"Hello World");
        this.template.sendBody("direct:bean", (Object)"Bye World");
        this.template.sendBody("direct:setBody", (Object)"Hi World");
        this.template.sendBody("direct:setHeader", (Object)"Hi Camel");
        this.template.sendBody("direct:setProperty", (Object)"Bye Camel");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead"));
                this.from("direct:transform").transform().method(TransformBeanExceptionTest.class, "throwUp");
                this.from("direct:bean").bean(TransformBeanExceptionTest.class, "throwUp");
                this.from("direct:setBody").setBody().method(TransformBeanExceptionTest.class, "throwUp");
                this.from("direct:setHeader").setHeader("hello").method(TransformBeanExceptionTest.class, "throwUp");
                this.from("direct:setProperty").setProperty("bye").method(TransformBeanExceptionTest.class, "throwUp");
            }
        };
    }

    public static String throwUp(String body) {
        throw new IllegalArgumentException("Forced");
    }
}

