/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.TryDefinition;

public class TryFinallyCaughtExceptionTest
extends ContextTestSupport {
    public void testTryFinallyCaughtException() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        MockEndpoint error = this.getMockEndpoint("mock:b");
        error.expectedMessageCount(1);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            TryFinallyCaughtExceptionTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
        Exception e = (Exception)((Exchange)error.getReceivedExchanges().get(0)).getProperty("CamelExceptionCaught", Exception.class);
        TryFinallyCaughtExceptionTest.assertNotNull((Object)e);
        TryFinallyCaughtExceptionTest.assertEquals((String)"Forced", (String)e.getMessage());
        String to = (String)((Exchange)error.getReceivedExchanges().get(0)).getProperty("CamelFailureEndpoint", String.class);
        TryFinallyCaughtExceptionTest.assertEquals((String)"bean://myBean?method=doSomething", (String)to);
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myBean", (Object)this);
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().to("mock:a")).to("bean:myBean?method=doSomething")).doFinally().to("mock:b")).end().to("mock:result");
            }
        };
    }

    public void doSomething(String body) throws Exception {
        throw new IllegalArgumentException("Forced");
    }
}

