/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.processor.MyValidator;

public class ValidationFinallyBlockTest
extends ContextTestSupport {
    protected Processor validator = new MyValidator();
    protected MockEndpoint validEndpoint;
    protected MockEndpoint invalidEndpoint;
    protected MockEndpoint allEndpoint;

    public void testValidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.invalidEndpoint.expectedMessageCount(0);
        this.allEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"<valid/>", "foo", (Object)"bar");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.allEndpoint});
    }

    public void testInvalidMessage() throws Exception {
        this.invalidEndpoint.expectedMessageCount(1);
        this.validEndpoint.expectedMessageCount(0);
        this.allEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"<invalid/>", "foo", (Object)"notMatchedHeaderValue");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.allEndpoint});
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.validEndpoint = this.resolveMandatoryEndpoint("mock:valid", MockEndpoint.class);
        this.invalidEndpoint = this.resolveMandatoryEndpoint("mock:invalid", MockEndpoint.class);
        this.allEndpoint = this.resolveMandatoryEndpoint("mock:all", MockEndpoint.class);
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                TryDefinition tryType = (TryDefinition)((TryDefinition)this.from("direct:start").doTry().process(ValidationFinallyBlockTest.this.validator)).to("mock:valid");
                tryType.doCatch(ValidationException.class).to("mock:invalid");
                tryType.doFinally().to("mock:all");
            }
        };
    }
}

